using System;
using System.Web.Mvc;
using System.Web.Routing;

using HIPS.Web.Components.Web;

namespace HIPS.Web.UI
{

    /// <summary>
    /// MVC route configuration.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="18 January 2014">Initial version.</change>
    /// </history>
    public class RouteConfig
    {

        /// <summary>
        /// Register MVC routes.
        /// </summary>
        /// <param name="routes">Collection to add routes to.</param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 January 2014">Initial version.</change>
        /// </history>
        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            //PCEHR View specific routes:

            System.Func<object, string> titleMethod;

            //PD View:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Prescription and Dispense View for {0}", vm.CurrentPatient.Name) : string.Empty;
            };

            /* PD View Rendered */
            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView/Content/View",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseViewContentView" }
                ).SetTitle(titleMethod);

            /* PD View IFrame */
            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView/Content",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseViewContent" }
                ).SetTitle(titleMethod);

            /* PD View wrapper with filters */
            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseView" }
                ).SetTitle(titleMethod);

            //Document:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return string.Format("{0} for {1}", vm.CurrentDocument.CategoryName, vm.CurrentPatient.Name);
            };

            /* Document Rendered */
            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}/Content/View/{filename}",
                defaults: new { controller = "PcehrView", action = "DocumentContentView" }
                ).SetTitle(titleMethod);

            /* Document IFrame Wrapper */
            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}/Content",
                defaults: new { controller = "PcehrView", action = "DocumentContent" }
                ).SetTitle(titleMethod);

            /* Document Wrapper, Header etc. */
            routes.MapRoute(
                name: "PcehrView-Document",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}",
                defaults: new { controller = "PcehrView", action = "Document" }
                ).SetTitle(titleMethod);

            //Gain Access:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Gain Access for {0}", vm.CurrentPatient.Name) : string.Empty;
            };

            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/GainAccess",
                defaults: new { controller = "PcehrView", action = "GainAccess" }
                ).SetTitle(titleMethod);

            //Patient:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Patient Summary for {0}", vm.CurrentPatient.Name) : string.Empty;
            };

            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PatientSummary",
                defaults: new { controller = "PcehrView", action = "PatientSummary" }
                ).SetTitle(titleMethod);

            //Hospitals / Patients:

            titleMethod = (m) =>
                {
                    var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                    return vm.IsHospitalSelected() ? string.Format("Patients at {0}", vm.CurrentHospital.Name) : "Hospitals";
                };

            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals/{hospitalId}/Patients",
                defaults: new { controller = "PcehrView", action = "Patients" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: "",
                url: "PcehrView/Hospitals",
                defaults: new { controller = "PcehrView", action = "Hospitals" }
                ).SetTitle(titleMethod);

            //Generic routes:

            routes.MapRoute(
                name: "Default",
                url: "{controller}/{action}/{id}",
                defaults: new { controller = "Home", action = "Index", id = UrlParameter.Optional });

        }
    }
}
